<?php

namespace SJB\Analytics;

use KISSmetrics\Client;
use KISSmetrics\Transport\Sockets;

class Logger
{
	public static function log($event, $params = [])
	{
		if (!\SJB_System::getSystemSettings('isSaas')) {
		    return;
        }

        $billingEmail = \SJB_Settings::getValue('billing_email');
        if (!$billingEmail) {
            $response = \SJB_H::whmcsCall('getemailbydomain', [
                'domain' => \SJB_System::getSystemSettings('HTTPHOST'),
            ]);
            if (empty($response['email'])) {
                return;
            }
            $billingEmail = $response['email'];
            \SJB_Settings::saveSetting('billing_email', $billingEmail);
        }

        try {
            $params = array_merge(['Trial Name' => \SJB_System::getSystemSettings('HTTPHOST')], $params);
            $km = new Client(\SJB_System::getSystemSettings('env')['Kissmetrics']['key'], Sockets::initDefault());
            $km->identify($billingEmail)
                ->record($event, $params)
                ->submit();
        } catch (\Exception $ex) {}
	}
}
