<select type="text" name="{$id}" id="{$id}">
    {if $value}
        <option value="{$value|escape}" selected="selected">{$listing.user.username}</option>
    {/if}
</select>

{javascript}

    <link href="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.3/css/select2.min.css" rel="stylesheet" />
    <script src="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.3/js/select2.min.js"></script>
    <script>
        $(document).ready(function () {
            var userSelector = $('#{$id}').select2({
                placeholder: '{if $user_group.name == 'Job Seeker'}[[Enter full name or email]]{else}[[Enter company name or email]]{/if}',
                {if $allow_empty}
                    allowClear: true,
                {/if}
                ajax: {
                    url: window.SJB_AdminSiteUrl + '/manage-users/{$user_group.id|lower}/',
                    dataType: 'json',
                    delay: 150,
                    data: function (params) {
                        return {
                            'username[user_like]': params.term, // search term
                            page: params.page,
                            action: 'search',
                            format: 'json',
                            minLength: 0,
                            itemsPerPage: 20,
                            page: 1
                        };
                    },
                    processResults: function (data, params) {
                        // parse the results into the format expected by Select2
                        // since we are using custom formatting functions we do not need to
                        // alter the remote JSON data, except to indicate that infinite
                        // scrolling can be used
                        params.page = params.page || 1;
                        for (var i = 0; i < data.length; i++) {
                            {if $value_type == 'sid'}
                                data[i].id = data[i].sid;
                            {else}
                                data[i].id = data[i].username;
                            {/if}
                        }
                        return {
                            results: data,
                            pagination: {
                                more: false
                            }
                        };
                    },
                    cache: true
                },
                escapeMarkup: function (markup) { return markup; }, // let our custom formatter work
                templateResult: function(res) {
                    if (res.loading) {
                        return res.text;
                    }
                    var item = '';
                    if (res.CompanyName) {
                        item += res.CompanyName;
                    }
                    if (!item && res.FullName) {
                        item += res.FullName;
                    }
                    item += '<div class="select2__email">' + res.username + '</div>';
                    return item;
                },
                templateSelection: function(res) {
                    if (res.text) {
                        return res.text;
                    }
                    return res.CompanyName ? res.CompanyName : res.email;
                }
            });
        });
    </script>
{/javascript}
