<?php

return [
    'SL-141', function() {
        $phrases = [
            [
                'phrase' => 'Thank you! Your account will be active as soon as it is reviewed and approved.',
                'translations' => [
                    'en' => 'Thank you! Your account will be active as soon as it is reviewed and approved.',
                    'de' => '',
                    'es' => '',
                    'fr' => '',
                    'ru' => 'Спасибо! Ваш аккаунт будет активирован после рассмотрения администрацией сайта.'
                ]
            ],
        ];
        foreach ($phrases as $phrase) {
            foreach ($phrase['translations'] as $lang => $translation) {
                $langFile = SJB_BASE_DIR . "languages/{$lang}.pages.xml";
                if (file_exists($langFile)) {
                    file_put_contents(
                        $langFile,
                        str_replace(
                            '<page key="Frontend">',
                            sprintf(
                                '<page key="Frontend">
                                   <string key="%s">
                                     <tr lang="%s"> %s </tr>
                                   </string>',
                                XML_Util::replaceEntities($phrase['phrase']),
                                $lang,
                                XML_Util::replaceEntities($translation)
                            ),
                            file_get_contents($langFile)
                        )
                    );
                }
            }
        }
        return true;
    },
    'bounce-emails', function() {
        SJB_DB::query('update `users` set username = replace(username, "@test.com", "@mysmartjobboard.com") where sid < 10 and username like "%@test.com"');
        return true;
    },
    'SL-143-stripe', function() {
        $success = SJB_DB::query('ALTER TABLE `payment_gateways` ADD `name` VARCHAR(255) NULL AFTER `id`;');
        $success &= SJB_DB::query('UPDATE `payment_gateways` SET `name` = `caption`');
        $success &= SJB_DB::query('UPDATE `payment_gateways` SET `caption` = "Credit Card" where `id` in ("authnet_sim", "paypal_pro")');
        $success &= SJB_DB::query('UPDATE `payment_gateways` SET `caption` = "PayPal" where `id` = "paypal_standard"');
        return $success && SJB_DB::query('INSERT INTO `payment_gateways` (`id`, `name`, `caption`, `active`) VALUES ("stripe", "Stripe", "Credit Card", 0)');
    },
    'SL-146-invoice-payment', function() {
        $success = true;
        if (!SJB_DB::queryValue('select 1 from `user_profile_fields` where user_group_sid = "41" and id = "Phone"')) {
            $success &= (bool) SJB_DB::query('update `user_profile_fields` set `order` = `order` + 1 where user_group_sid = 41 and `order` > 3');
            $success &= (bool) SJB_DB::query('INSERT INTO `user_profile_fields` (`user_group_sid`, `order`, `id`, `caption`, `type`, `default_value`, `is_required`, `instructions`, `maxlength`, `width`, `height`, `second_width`, `second_height`, `template`, `level_1`, `level_2`, `level_3`, `level_4`, `display_as_select_boxes`, `parent_sid`, `hidden`, `display_as`, `choiceLimit`) VALUES (\'41\', \'4\', \'Phone\', \'Phone\', \'string\', NULL, \'0\', \'\', \'256\', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, \'0\', NULL, \'0\', NULL, \'0\')');
        }
        $success &= (bool) SJB_DB::query('ALTER TABLE `users` ADD `Phone` VARCHAR(255) NULL');
        $success &= (bool) SJB_DB::query('update `email_templates` set `name` = "Order Confirmation" where `name` = "Product Purchase Confirmation"');
        $success &= (bool) SJB_DB::query('update `email_templates` set `hidden` = 1 where `name` = "Product Purchase Confirmation for Admin"');
        $success &= (bool) SJB_DB::query('UPDATE `pages` SET `pass_parameters_via_uri` = \'1\', `function` = \'invoice\', `access_type` = \'user\', `parameters` = \'a:0:{}\', `uri` = \'/invoice/\' WHERE `uri` = "/print-invoice/";');
        if (!SJB_DB::queryValue('select 1 from payment_gateways where id = "invoice"')) {
            $success &= (bool) SJB_DB::query('INSERT INTO `payment_gateways` (`id`, `name`, `caption`, `active`) VALUES ("invoice", "Invoice", "Pay by Invoice", 0)');
        }
        $phrases = [
            [
                'phrase' => 'Invoice',
                'translations' => [
                    'en' => 'Invoice',
                    'de' => '',
                    'es' => '',
                    'fr' => '',
                    'ru' => 'Счет Фактура'
                ]
            ],
            [
                'phrase' => 'Bill To',
                'translations' => [
                    'en' => 'Bill To',
                    'de' => '',
                    'es' => '',
                    'fr' => '',
                    'ru' => 'Плательщик'
                ]
            ],
            [
                'phrase' => 'Send Payment To',
                'translations' => [
                    'en' => 'Send Payment To',
                    'de' => '',
                    'es' => '',
                    'fr' => '',
                    'ru' => 'Получатель'
                ]
            ],
            [
                'phrase' => 'Amount',
                'translations' => [
                    'en' => 'Amount',
                    'de' => '',
                    'es' => '',
                    'fr' => '',
                    'ru' => 'Стоимость'
                ]
            ],
        ];
        foreach ($phrases as $phrase) {
            foreach ($phrase['translations'] as $lang => $translation) {
                $langFile = SJB_BASE_DIR . "languages/{$lang}.pages.xml";
                if (file_exists($langFile)) {
                    $success &= (bool) file_put_contents(
                        $langFile,
                        str_replace(
                            '<page key="Frontend">',
                            sprintf(
                                '<page key="Frontend">
                                   <string key="%s">
                                     <tr lang="%s"> %s </tr>
                                   </string>',
                                XML_Util::replaceEntities($phrase['phrase']),
                                $lang,
                                XML_Util::replaceEntities($translation)
                            ),
                            file_get_contents($langFile)
                        )
                    );
                }
            }
        }
        return $success;
    },
    '5.0.4', function() {
        ThemeManager::compileStyles();
        SJB_TemplateProcessor::deleteCache();
        return true;
    },
    'SL-154', function() {
        $success = (bool) SJB_DB::query('ALTER TABLE `payment_gateways` ADD `position` INT NULL DEFAULT NULL');
        $success &= (bool) SJB_DB::query('UPDATE `payment_gateways` SET `position` = 0 WHERE `id` = "stripe"');
        $success &= (bool) SJB_DB::query('UPDATE `payment_gateways` SET `position` = 1 WHERE `id` = "paypal_standard"');
        $success &= (bool) SJB_DB::query('UPDATE `payment_gateways` SET `position` = 2 WHERE `id` = "paypal_pro"');
        $success &= (bool) SJB_DB::query('UPDATE `payment_gateways` SET `position` = 3 WHERE `id` = "authnet_sim"');
        $success &= (bool) SJB_DB::query('UPDATE `payment_gateways` SET `position` = 4 WHERE `id` = "2checkout"');
        $success &= (bool) SJB_DB::query('UPDATE `payment_gateways` SET `position` = 5 WHERE `id` = "invoice"');
        return $success;
    },
];
