<?php

return [
    'SL-226', function() {
        $success = true;
        $phrases = [
            'Email me jobs from $company_name' => [
                'en' => 'Email me jobs from $company_name',
                'ru' => 'Подписаться на вакансии от $company_name',
            ],
            'Featured' => [
                'en' => 'Featured',
                'ru' => 'срочно',
            ],
        ];

        foreach (['de', 'en', 'es', 'fr', 'ru', 'nl', 'ro', 'th'] as $lang) {
            $langFile = SJB_BASE_DIR . "languages/{$lang}.pages.xml";
            if (!file_exists($langFile)) {
                continue;
            }
            $contents = file_get_contents($langFile);
            foreach ($phrases as $phrase => $translations) {
                $trans = '';
                if (!empty($translations[$lang])) {
                    $trans = $translations[$lang];
                }
                $contents = str_replace(
                    '<page key="Frontend">',
                    sprintf(
                        join("\n", [
                            '<page key="Frontend">',
                            '      <string key="%s">',
                            '        <tr lang="%s"> %s </tr>',
                            '      </string>',
                        ]),
                        XML_Util::replaceEntities($phrase),
                        $lang,
                        XML_Util::replaceEntities($trans)
                    ),
                    $contents
                );
            }
            $success &= (bool) file_put_contents($langFile, $contents);
        }
        return $success;
    },
    '5.0.11', function() {
        ThemeManager::compileStyles();
        SJB_TemplateProcessor::deleteCache();
        return true;
    },
];
