<?php

class SJB_EmailTemplateDetails extends SJB_ObjectDetails
{
    var $properties;
    var $details;

    public function __construct($info)
    {
        foreach (self::getDetails() as $detail_info) {
            $detail_info['value'] = '';
            if (isset($info[$detail_info['id']])) {
                $detail_info['value'] = $info[$detail_info['id']];
            }
            $this->properties[$detail_info['id']] = new SJB_ObjectProperty($detail_info);
        }
    }

    public static function getDetails()
    {
        return [
            [
                'id' => 'name',
                'caption' => 'Template Name',
                'type' => 'string',
                'length' => '20',
                'is_required' => true,
                'is_system' => true,
                'order' => 1,
            ],
            [
                'id' => 'cc',
                'caption' => 'CC',
                'type' => 'email',
                'is_required' => false,
                'is_system' => true,
                'order' => 2,
            ],
            [
                'id' => 'subject',
                'caption' => 'Subject',
                'type' => 'string',
                'is_required' => false,
                'is_system' => true,
                'order' => 3,
            ],
            [
                'id' => 'text',
                'caption' => 'Text',
                'type' => 'text',
                'is_required' => false,
                'is_system' => true,
                'order' => 4,
            ],
            [
                'id' => 'active',
                'caption' => 'Active',
                'comment' => '<span class="tooltip-checkbox" data-toggle="tooltip" data-placement="auto left" title="Deactivated emails will not be sent."><i class="fa fa-question-circle" aria-hidden="true"></i></span>',
                'type' => 'boolean',
                'is_required' => false,
                'is_system' => true,
                'order' => 5,
            ],
        ];
    }
}
