<?php

return [
    'SL-319', function() {
        return SJB_DB::query('update `email_templates` set `text` = replace(`text`, \'{$applicant_request.comments}\', \'<span style="white-space: pre-line;">{$applicant_request.comments}</span>\') where `name` = "Application Email to Employer"');
    },
    'SJB-317', function() {
        return SJB_DB::query("ALTER TABLE `email_templates` ADD `active` TINYINT(1) NOT NULL DEFAULT '1'");
    },
    'SL-302', function() {
        $success = true;
        $phrases = [
            'Sign in with Facebook' => [
                'en' => 'Sign in with Facebook',
                'ru' => 'Войти через Facebook',
            ],
        ];

        foreach (['de', 'en', 'es', 'fr', 'ru', 'nl', 'ro', 'th', 'no'] as $lang) {
            $langFile = SJB_BASE_DIR . "languages/{$lang}.pages.xml";
            if (!file_exists($langFile)) {
                continue;
            }
            $contents = file_get_contents($langFile);
            foreach ($phrases as $phrase => $translations) {
                $trans = '';
                if (!empty($translations[$lang])) {
                    $trans = $translations[$lang];
                }
                $contents = str_replace(
                    '<page key="Frontend">',
                    sprintf(
                        join("\n", [
                            '<page key="Frontend">',
                            '      <string key="%s">',
                            '        <tr lang="%s"> %s </tr>',
                            '      </string>',
                        ]),
                        XML_Util::replaceEntities($phrase),
                        $lang,
                        XML_Util::replaceEntities($trans)
                    ),
                    $contents
                );
            }
            $success &= (bool) file_put_contents($langFile, $contents);
        }
        $success &= SJB_DB::query('drop table `facebook`');
        $success &= SJB_DB::query('drop table `linkedin`');
        $success &= SJB_DB::query('delete from `pages` where `uri` = "/registration-social/" or `uri` = "/social/"');
        $success &= SJB_DB::query('delete from `settings` where `name` = "fb_appID" or `name` = "fb_appSecret"');

        $rmdirs = [
            SJB_BASE_DIR . 'system/plugins/linkedin_social_plugin',
            SJB_BASE_DIR . 'system/plugins/facebook_social_plugin',
        ];
        foreach ($rmdirs as $rmdir) {
            if (file_exists($rmdir)) {
                $iterator = new RecursiveDirectoryIterator($rmdir, FilesystemIterator::SKIP_DOTS);
                $iterator = new RecursiveIteratorIterator($iterator, RecursiveIteratorIterator::CHILD_FIRST);
                foreach ($iterator as $file) {
                    if ($file->isDir()) {
                        @rmdir($file->getPathName());
                    }
                    @unlink($file->getPathName());
                }
                @rmdir($rmdir);
            }
        }

        return $success;
    },
    'SL-325', function() {
        return SJB_DB::query('update `email_templates`
          set `text` = replace(replace(replace(`text`, ".FullName}", ".FullName|escape}"), "|location}", "|location|escape}"), ".CompanyName}", ".CompanyName|escape}")
        ');
    },
    '5.0.13', function() {
        ThemeManager::compileStyles();
        SJB_TemplateProcessor::deleteCache();
        return true;
    },
];
