{breadcrumbs}[[Refine Search Settings]]{/breadcrumbs}
<div class="page-title">
    <h1 class="title">[[Refine Search Settings]]</h1>
</div>

<form method="post" action="" class="form-inline" style="margin-bottom: 25px;">
	<input type="hidden" name="action" value="save_setting" />
	<div class="form-group with-tooltip">
        [[Items Limit]]:
        <div class="input-group m-t-10">
            <input type="text" name="refine_search_items_limit" value="{$refine_search_items_limit}" />
            <span class="input-group-btn">
                <input type="submit" value="[[Save]]" class="greenButton"/>
            </span>
        </div>
        <span class="tooltip__refine-search" data-toggle="tooltip" data-placement="auto left" title="[[Specify the limit for the number of items to be displayed in Refine Search blocks]]"><i class="fa fa-question-circle" aria-hidden="true"></i></span>
    </div>
</form>

{foreach from=$listingTypes item=listingType}
    <div class="panel panel-default panel--wide">
        <div class="panel-heading">
            <h3 class="panel-title">[[{$listingType.id} Search]]</h3>
        </div>
        <form method="post" action="" class="panel-body">
            <input type="hidden" name="action" value="save_setting" />
            <input type="hidden" name="listing_type_id" value="{$listingType.id}" />
            <input type="hidden" name="turn_on_refine_search_{$listingType.id}" value="0">
            <label class="cr-styled">
                <input type="checkbox" name="turn_on_refine_search_{$listingType.id}"  value="1" {if $listingType.setting}checked{/if} onchange='form.submit();' />
                <i class="fa"></i>
                [[Turn on Refine Search]]
            </label>
        </form>
        <form method="post" action="" class="refine-block">
            <input type="hidden" name="action" value="save" />
            <input type="hidden" name="listing_type_sid" value="{$listingType.sid}" />
            <select name="field_id" class="left">
                {foreach from=$listingType.fields item=fields}
                    <option value="{$fields.sid}">[[{$fields.caption}]]</option>
                {/foreach}
                {if $listingType.user_fields.id}
                    <option value="user_{$listingType.user_fields.sid}">{$listingType.user_fields.id}</option>
                {/if}
            </select>
            <input type="submit" value="[[Add]]" class="grayButton" />
        </form>
        <br/>
        <div class="panel-body">
            <div class="table-responsive">
                <table class="table table-striped">
                    <thead>
                        <tr>
                            <th>[[Field Name]]</th>
                            <th colspan="3" width="1%" class="actions">[[Actions]]</th>
                        </tr>
                    </thead>
                    {foreach from=$listingType.saved_fields item=saved_fields name=items_block}
                    <tr class="{cycle values = 'evenrow,oddrow'}">
                        <td width="100%">[[{$saved_fields.caption}]]</td>
                        <td nowrap="nowrap"><a href="?field_id={$saved_fields.id}&action=delete" onclick='return confirm("[[Are you sure you want to delete this field?]]")' title="[[Delete]]"><i class="ion-close-circled"></i></a></td>
                        <td nowrap="nowrap">
                            {if $smarty.foreach.items_block.iteration < $smarty.foreach.items_block.total}
                                <a href="?field_id={$saved_fields.id}&amp;listing_type_sid={$listingType.sid}&amp;action=move_down"><img src="{image}b_down_arrow.gif" border="0" alt=""/></a>
                            {/if}
                        </td>
                        <td nowrap="nowrap">
                            {if $smarty.foreach.items_block.iteration > 1}
                                <a href="?field_id={$saved_fields.id}&amp;listing_type_sid={$listingType.sid}&amp;action=move_up"><img src="{image}b_up_arrow.gif" border="0" alt=""/></a>
                            {/if}
                        </td>
                    </tr>
                    {/foreach}
                </table>
            </div>
        </div>
    </div>
    <br/>
{/foreach}