<div class="page-title">
	<h1 class="title">[[Admin Password]]</h1>
</div>

{if $action eq "change_admin_account" && !$errors}
	<p class="message">[[Your login details were successfully changed.]]</p>
{else}
	{foreach from=$errors key=field_caption item=error}
		{if $error eq 'EMPTY_VALUE'}
			{assign var="field_caption" value=$field_caption|tr}
			<p class="error">[[Please enter '$field_caption']]</p>
		{elseif $error eq 'NOT_UNIQUE_VALUE'}
			<p class="error">'[[{$field_caption}]]' [[this value is already used in the system]]</p>
		{elseif $error eq 'INVALID_PASSWORD'}
			<p class="error">[[Current Administrator's Password is incorrect]]</p>
		{elseif $error eq 'NOT_CONFIRMED'}
			<p class="error">[[Passwords did not match]]</p>
		{else}
			<p class="error">[[{$error}]]</p>
		{/if}
	{/foreach}
{/if}

<div class="panel panel-default panel--max">
	<div class="panel-heading">
		<h3 class="panel-title">[[Change Administrator's Username and Password]]</h3>
	</div>
	<form method="post" class="panel-body">
		<input type="hidden" name="action" value="change_admin_account" />
		<div class="form-horizontal">
			<div class="form-group">
				<label class="col-md-2 control-label">[[Current Username]]</label>
				<div class="col-md-7">
					<label class="control-label">{$adminInfo.username}</label>
				</div>
			</div>
			{foreach from=$form_fields key=item_name item=form_field}
				<div class="form-group">
					<label class="col-md-2 control-label">
						[[{$form_field.caption}]]
						<span class="required">
							{if $form_field.is_required}*{/if}
						</span>
					</label>
					<div class="col-md-7">
						{if $form_field.id == 'password'}
							{input property=$form_field.id template='password_cur.tpl'}
						{else}
							{input property=$form_field.id}
						{/if}
					</div>
				</div>
			{/foreach}
			<div class="form-group">
				<div class="col-md-7 col-md-offset-2">
					<input type="submit" value="[[Save]]" class="grayButton" />
				</div>
			</div>
		</div>
	</form>
</div>