<?php

class SJB_Admin_Payment_UserProduct extends SJB_Function
{
    public function isAccessible()
    {
        $this->setPermissionLabel(SJB_Acl::ADMIN_JOB_BOARD);
        return parent::isAccessible();
    }

	public function execute()
	{
		$tp = SJB_System::getTemplateProcessor();
		$userSID = SJB_Request::getVar('user_sid', false);
		$page = SJB_Request::getVar('page', '');
		$action = SJB_Request::getVar('action', false);
		$user = SJB_UserManager::getUserInfoBySID($userSID);
		$contractID = SJB_Request::getVar("contract_id", 0);
		if ($user) {
			switch ($page) {
				case 'add_product':
					if ($action == 'add_product') {
						$productSID = SJB_Request::getVar('product_sid', false);
						$listingNumber = SJB_Request::getVar('number_of_listings_' . $productSID, null);
						if ($productSID) {
							$productInfo = SJB_ProductsManager::getProductInfoBySID($productSID);
							$listingNumber = $listingNumber?$listingNumber:(!empty($productInfo['number_of_listings'])?$productInfo['number_of_listings']:null);
							$contract = new SJB_Contract(array('product_sid' => $productSID, 'numberOfListings' => $listingNumber));
							$contract->setUserSID($userSID);
							$contract->saveInDB();
							if ($contract->isFeaturedProfile()) {
								SJB_UserManager::makeFeaturedBySID($userSID);
							}
							$tp->assign('contract_added', 1);
						}
						else
							$errors['UNDEFINED_PRODUCT_SID'] = 1;
					}

					$products = SJB_ProductsManager::getUserGroupProducts($user['user_group_sid']);
					$tp->assign('user_sid', $userSID);
					$tp->assign('products', $products);
					$tp->display('add_user_product.tpl');
					break;

				case 'user_products':
					if ($action == 'remove') {
						SJB_ContractManager::deleteContract($contractID, $userSID);
					} elseif ($action == 'activate') { 
						SJB_ContractManager::activateContract($contractID, $userSID);
					}
					$contracts = SJB_ContractManager::getAllContractsInfoByUserSID($userSID);
					$listingTypes = SJB_ListingTypeManager::getAllListingTypesInfo();
					$acl = SJB_Acl::getInstance();
					foreach ($contracts as $key => $contractInfo) {
						$contractInfo['extra_info'] = unserialize($contractInfo['serialized_extra_info']);
						$contractInfo['availableView'] = array();
						$contractInfo['availableContactViews'] = array();
						$contractInfo['listingAmount'] = array();
						foreach ($listingTypes as $listingType) {
							$listingTypeID = $listingType['id'];
							if ($acl->isAllowed('post_' . $listingTypeID, $contractInfo['id'], 'contract')) {
								$contractInfo['listingAmount'][$listingTypeID]['name'] = $listingType['name'];
								$permissionParam = $acl->getPermissionParams('post_' . $listingTypeID, $contractInfo['id'], 'contract');
								$contractInfo['listingAmount'][$listingTypeID]['numPostings'] = SJB_ContractManager::getListingsNumberByContractSIDsListingType(array($contractInfo['id']), $listingType['id']);
								if (empty($permissionParam)) {
									$contractInfo['listingAmount'][$listingTypeID]['count'] = 'unlimited';
									$contractInfo['listingAmount'][$listingTypeID]['listingsLeft'] = 'unlimited';
								}
								else {
									$contractInfo['listingAmount'][$listingTypeID]['count'] = $permissionParam;
									$contractInfo['listingAmount'][$listingTypeID]['listingsLeft'] = $contractInfo['listingAmount'][$listingTypeID]['count'] - $contractInfo['listingAmount'][$listingTypeID]['numPostings'];
								}
							}
						}
	
						$contracts[$key] = $contractInfo;
						$contracts[$key]['product'] = SJB_ProductsManager::getProductInfoBySID($contractInfo['product_sid']);
					}
					$userInfo = SJB_UserManager::getUserInfoBySID($userSID);
					$userGroupInfo = SJB_UserGroupManager::getUserGroupInfoBySID($userInfo['user_group_sid']);
					$tp->assign("user_group_info", $userGroupInfo);
					$tp->assign('contracts', $contracts);
					$tp->assign('user_sid', $userSID);
					$tp->display('user_products.tpl');
					break;
			}
		}
		else {
			$errors['USER_DOES_NOT_EXIST'] = 1;
			$tp->assign('errors', $errors);
			$tp->display('../users/error.tpl');
		}
	}
}
