<?php

class SJB_Notifications
{
    public static function sendUserPasswordChangeLetter($user_sid)
    {
        $user = SJB_UserManager::getObjectBySID($user_sid);
        $user_info = SJB_UserManager::createTemplateStructureForUser($user);
        $data = ['user' => $user_info];
        return SJB_EmailTemplateEditor::getEmail($user_info['username'], self::getEmailSid('Password Recovery'), $data)->send();
    }

    /**
     * @static
     * @param array $listing_info
     * @return null
     */
    public static function sendUserListingExpiredLetter($listing_info)
    {
        $userGroupSID = SJB_Array::getPath($listing_info, 'user/user_group_sid');
        $emailTplSID = SJB_UserGroupManager::getEmailTemplateSIDByUserGroupAndField($userGroupSID, 'notify_on_listing_expiration');
        $user_info = SJB_Array::get($listing_info, 'user');
        $data = ['user' => $user_info, 'listing' => $listing_info];
        $email = SJB_EmailTemplateEditor::getEmail($user_info['username'], $emailTplSID, $data);

        return $email->send();
    }

    public static function sendUserContractExpiredLetter($userInfo, $contractInfo, $productInfo)
    {
        $user = SJB_UserManager::getObjectBySID($userInfo['sid']);
        if (!$user) {
            return false;
        }

        $userGroupSID = $user->getUserGroupSID();
        $emailTplSID = SJB_UserGroupManager::getEmailTemplateSIDByUserGroupAndField($userGroupSID, 'notify_on_contract_expiration');

        $user_info = SJB_UserManager::createTemplateStructureForUser($user);
        $productInfo = array_merge($productInfo, SJB_ProductsManager::createTemplateStructureForProductForEmailTpl($productInfo));
        $data = [
            'user' => $user_info,
            'product' => $productInfo,
            'contract' => $contractInfo
        ];
        $email = SJB_EmailTemplateEditor::getEmail($userInfo['username'], $emailTplSID, $data);
        return $email->send();
    }

    /**
     * @param \SJB\Admins\Admin $admin
     * @return array|bool
     */
    public static function sendAdminInvite($admin)
    {
        $data = [
            'inviter' => SJB_Session::getValue('admin'),
            'admin' => [
                'name' => $admin->getPropertyValue('name'),
                'email' => $admin->getPropertyValue('email'),
                'hash' => $admin->getHash(),
            ],
        ];
        return SJB_EmailTemplateEditor::getEmail($admin->getPropertyValue('email'), self::getEmailSid('Admin Invite'), $data)->send();
    }

    public static function getEmailSid($name)
    {
        return SJB_DB::queryValue('select `sid` from `email_templates` where `name` = ?s', $name);
    }

    /**
     * @param array $admin
     * @return array
     */
    public static function sendAdminRecover($admin)
    {
        $data = [
            'admin' => $admin,
        ];
        return SJB_EmailTemplateEditor::getEmail($admin['email'], self::getEmailSid('Admin Recover'), $data)->send();
    }

    /**
     * @param SJB_Listing $listing
     * @param $user_sid
     * @return mixed
     */
    public static function sendUserListingActivatedLetter(SJB_Listing $listing, $user_sid)
    {
        $user = SJB_UserManager::getObjectBySID($user_sid);
        $userGroupSID = $user->getUserGroupSID();
        $emailTplSID = SJB_UserGroupManager::getEmailTemplateSIDByUserGroupAndField($userGroupSID, 'notify_on_listing_activation');

        $user_info = SJB_UserManager::createTemplateStructureForUser($user);
        $listing_info = SJB_ListingManager::createTemplateStructureForListing($listing);
        $data = [
            'listing' => $listing_info,
            'user' => $user_info
        ];
        $email = SJB_EmailTemplateEditor::getEmail($user_info['username'], $emailTplSID, $data);
        return $email->send();
    }

    public static function sendApplyNow($info, $file = '', $data_resume = [], $userData = false)
    {
        $application_email = SJB_Applications::getApplicationEmailbyListingId($info['listing']['id']);
        $email_address = !empty($application_email) ? $application_email : $info['listing']['user']['username'];

        $data = [
            'user' => SJB_Array::getPath($info, 'listing/user'),
            'listing' => $info['listing'],
            'applicant_request' => $info['submitted_data'],
            'data_resume' => $data_resume,
        ];

        $email = SJB_EmailTemplateEditor::getEmail($email_address, self::getEmailSid('Application Email to Employer'), $data);
        $email->setFromName($info['submitted_data']['name'] . ' via ' . SJB_Settings::getValue('site_title'));
        $email->setReplyTo($userData['email']);
        if ($file != '') {
            $email->setFile($file);
        }
        return $email->send();
    }

    /**
     * @param $userSID
     * @param $productInfo
     * @param SJB_Invoice $invoice
     * @return mixed
     */
    public static function sendSubscriptionActivationLetter($userSID, $productInfo, $invoice)
    {
        $user = SJB_UserManager::getObjectBySID($userSID);
        $user = SJB_UserManager::createTemplateStructureForUser($user);
        $productExtraInfo = SJB_ProductsManager::getProductExtraInfoBySID($productInfo['sid']);
        $productInfo = array_merge($productInfo, $productExtraInfo);
        $fields = SJB_ProductsManager::createTemplateStructureForProductForEmailTpl($productInfo);
        $product = array_merge($fields, $productExtraInfo);
        $tax = 0;
        if ($invoice->getPropertyValue('tax_info')) {
            $taxInfo = $invoice->getPropertyValue('tax_info');
            $tax = $taxInfo['tax_amount'];
        }
        $data = [
            'user' => $user,
            'product' => $product,
            'invoice' => [
                'id' => $invoice->getSID(),
                'sub_total' => $invoice->getPropertyValue('sub_total'),
                'total' => $invoice->getPropertyValue('total'),
                'tax' => $tax,
                'date' => $invoice->getPropertyValue('date'),
                'hash' => $invoice->getHash(),
            ]
        ];

        $email = SJB_EmailTemplateEditor::getEmail($user['username'], self::getEmailSid('Order Confirmation'), $data);
        $result = $email->send();
        SJB_AdminNotifications::sendProductConfirmationLetter($data);
        return $result;
    }

    public static function sendUserWelcomeLetter($user_sid)
    {
        $user = SJB_UserManager::getObjectBySID($user_sid);
        $userGroupSID = $user->getUserGroupSID();
        $emailTplSID = SJB_UserGroupManager::getEmailTemplateSIDByUserGroupAndField($userGroupSID, 'welcome_email');

        $user = SJB_UserManager::createTemplateStructureForUser($user);
        $data = ['user' => $user];
        $email = SJB_EmailTemplateEditor::getEmail($user['username'], $emailTplSID, $data);
        return $email->send();
    }

    /**
     * @param array $listingsSIDs
     * @param array $guestAlertInfo
     * @param int $listingTypeSID
     * @return array|bool|null
     */
    public static function sendGuestAlertNewListingsFoundLetter(array $listingsSIDs, array $guestAlertInfo, $listingTypeSID)
    {
        $emailTplSID = SJB_ListingTypeManager::getListingTypeEmailTemplateForGuestAlert($listingTypeSID);

        $listings = [];
        foreach ($listingsSIDs as $listingSID) {
            $listing = SJB_ListingManager::getObjectBySID($listingSID);
            if ($listing instanceof SJB_Listing) {
                $listing = SJB_ListingManager::createTemplateStructureForListing($listing);
                array_push($listings, $listing);
            }
        }

        $data = [
            'listings' => $listings,
            'key' => $guestAlertInfo['alert_key']
        ];
        $email = SJB_EmailTemplateEditor::getEmail($guestAlertInfo['email'], $emailTplSID, $data);
        $email->setCustomHeader(sprintf('List-Unsubscribe: <%s/guest-alerts/unsubscribe/?key=%s>', SJB_H::getCustomDomainUrl(), rawurlencode($guestAlertInfo['alert_key'])));
        return $email->send();
    }
}
