<?php

class SJB_InvoiceDetails extends SJB_ObjectDetails
{
    public static function getDetails()
    {
        return [
            [
                'id' => 'user_sid',
                'caption' => 'Customer',
                'type' => 'id',
                'length' => '20',
                'table_name' => 'invoices',
                'is_required' => true,
                'is_system' => true,
            ],
            [
                'id' => 'status',
                'caption' => 'Invoice Status',
                'type' => 'list',
                'table_name' => 'invoices',
                'is_required' => true,
                'is_system' => true,
                'list_values' => [
                    [
                        'id' => 'Paid',
                        'caption' => 'Paid',
                    ],
                    [
                        'id' => 'Unpaid',
                        'caption' => 'Unpaid',
                    ],
                    [
                        'id' => 'Pending',
                        'caption' => 'Pending',
                    ],
                ],
            ],
            [
                'id' => 'date',
                'caption' => 'Invoice Date',
                'type' => 'date',
                'length' => '20',
                'table_name' => 'invoices',
                'is_required' => true,
                'is_system' => true,
            ],
            [
                'id' => 'payment_method',
                'caption' => 'Payment method',
                'type' => 'list',
                'table_name' => 'invoices',
                'is_required' => false,
                'is_system' => true,
                'list_values' => SJB_PaymentGatewayManager::getPaymentGatewaysNames(),
            ],
            [
                'id' => 'items',
                'caption' => 'Items',
                'type' => 'complex',
                'table_name' => 'invoices',
                'is_required' => false,
                'is_system' => true,
                'fields' => [
                    [
                        'id' => 'products',
                        'caption' => 'Items',
                        'type' => 'list',
                        'list_values' => [],
                        'length' => '20',
                        'is_required' => false,
                        'is_system' => true,
                        'order' => 1,
                    ],
                    [
                        'id' => 'qty',
                        'caption' => 'Qty',
                        'type' => 'integer',
                        'length' => '20',
                        'is_required' => false,
                        'is_system' => true,
                        'order' => 2,
                        'minimum' => 1,
                    ],
                    [
                        'id' => 'price',
                        'caption' => 'Price',
                        'type' => 'float',
                        'length' => '20',
                        'is_required' => false,
                        'is_system' => true,
                        'order' => 3,
                        'minimum' => 0,
                    ],
                    [
                        'id' => 'amount',
                        'caption' => 'Amount',
                        'type' => 'float',
                        'length' => '20',
                        'is_required' => false,
                        'is_system' => true,
                        'order' => 4,
                        'minimum' => 0,
                    ],
                    [
                        'id' => 'custom_item',
                        'caption' => 'Custom item',
                        'type' => 'string',
                        'length' => '20',
                        'is_required' => false,
                        'is_system' => true,
                        'order' => 5,
                    ],
                    [
                        'id' => 'custom_info',
                        'caption' => 'Custom info',
                        'type' => 'list',
                        'length' => '20',
                        'is_required' => false,
                        'is_system' => true,
                        'order' => 5,
                    ],
                ],
            ],
            [
                'id' => 'sub_total',
                'caption' => 'Sub Total',
                'type' => 'float',
                'length' => '20',
                'table_name' => 'invoices',
                'is_required' => false,
                'is_system' => true,
                'minimum' => 0,
            ],
            [
                'id' => 'tax_info',
                'caption' => 'Tax Info',
                'type' => 'complex',
                'table_name' => 'invoices',
                'is_required' => false,
                'is_system' => true,
                'fields' => [
                    [
                        'id' => 'tax_amount',
                        'caption' => 'Tax Amount',
                        'type' => 'float',
                        'length' => '20',
                        'table_name' => 'invoices',
                        'is_required' => false,
                        'is_system' => true,
                        'order' => 3,
                        'minimum' => 0,
                    ],
                    [
                        'id' => 'tax_rate',
                        'caption' => 'Tax Rate',
                        'type' => 'float',
                        'length' => '20',
                        'table_name' => 'invoices',
                        'is_required' => false,
                        'is_system' => true,
                        'order' => 5,
                        'minimum' => 0,
                    ],
                ],
            ],
            [
                'id' => 'total',
                'caption' => 'Total',
                'type' => 'float',
                'length' => '20',
                'table_name' => 'invoices',
                'is_required' => false,
                'is_system' => true,
                'minimum' => 0,
            ],
            [
                'id' => 'include_tax',
                'caption' => 'Include Tax',
                'type' => 'boolean',
                'length' => '20',
                'table_name' => 'invoices',
                'is_required' => false,
                'is_system' => true,
            ],
            [
                'id' => 'callback_data',
                'caption' => 'callback_data',
                'type' => 'text',
                'length' => '20',
                'table_name' => 'invoices',
                'is_required' => false,
                'is_system' => true,
            ],
        ];
    }
}
