{capture assign="trToDelete"}[[Are you sure you want to delete this product?]]{/capture}
{capture assign="trToCannotActivateProduct"}[[The product cannot be activated. Please change the availability date.]]{/capture}
{capture assign="trToProductForEmployers"}[[The product cannot be activated. This product is only for Employers. Please change the User Group.]]{/capture}

<div class="page-title page-title--wide">
	<h1 class="title">[[{$userGroup.name} Products]]</h1>
	<div class="page-title__buttons">
		<a href="{$GLOBALS.site_url}/add-product/?user_group_sid={$userGroup.sid}" class="btn btn--primary">[[Add New Product]]</a>
	</div>
</div>
<div class="errors">
	{if $errors}
		{foreach from=$errors key=error_code item=error_message}
			<p class="error">
				{if $error_code == 'PRODUCT_IS_IN_USE'} [[This product is in use. To delete the product, you need to first remove it from invoices and user subscriptions using it.]]{/if}
			</p>
		{/foreach}
	{/if}
</div>
<div class="panel panel-default panel--wide">
	<form method="post" action="{$GLOBALS.admin_site_url}/products/{$userGroup.id|lower}/" class="products__form">
		<div class="panel-body">
			<div class="table-responsive">
				<table class="table__products">
					<thead>
						<tr>
							<th style="width: 45px !important;"></th>
							<th style="width: 500px; white-space: normal;">[[Name]]</th>
							<th>[[Price]]</th>
							<th>[[Status]]</th>
							<th class="actions" width="1%"></th>
						</tr>
					</thead>
					<tbody>
						{foreach from=$products item=product}
							<tr>
								<td class="sortable-handle">...</td>
								<td style="width: 500px; white-space: normal;">
									<input type="hidden" name="products[]" value="{$product.sid}" />
									<a href="{$GLOBALS.site_url}/edit-product/?sid={$product.sid}" title="[[Edit]]">
										<strong>[[{$product.name|escape}]]</strong>
									</a>
									{if $userGroup.default_product == $product.sid}
										<div style="margin: 5px 0;">
											<small>
												[[Assigned to {$userGroup.name|lower} upon registration]]
											</small>
										</div>
									{/if}
								</td>
								<td>
									{capture assign="productPrice"}{tr type="float"}{$product.price}{/tr}{/capture}
									{if $product.period}
										{if $product.period_name == 'unlimited'}
											{currencyFormat amount=$productPrice}
										{else}
											{currencyFormat amount=$productPrice} [[per]] {$product.period} {if $product.period > 1 }[[{$product.period_name|capitalize}s]]{else}[[{$product.period_name|capitalize}]]{/if}
										{/if}
									{else}
										{currencyFormat amount=$productPrice}
									{/if}
								</td>
								<td>
									{if $product.active == 1}
										<span class="label label--active">[[Active]]</span>
									{else}
										<span class="label label--inactive">[[Not Active]]</span>
									{/if}
								</td>
								<td nowrap="nowrap">
									{if $product.subscribed_users || $product.invoices}
									{else}
										<a href="{$GLOBALS.site_url}/products/{$userGroup.id|lower}/?action=delete&sid={$product.sid}" onClick="return confirm('{$trToDelete|escape}');" title="[[Delete]]">
											<i class="ion-close-circled"></i>
										</a>
									{/if}
								</td>
							</tr>
						{/foreach}
					</tbody>
				</table>
			</div>
		</div>
	</form>
</div>
{javascript}
	<script>
		$(document).ready(function() {
			$('tbody').sortable({
				helper: function(e, ui) {
					ui.width(ui.width());
					return ui;
				},
				handle: '.sortable-handle',
				update: function() {
					$('.products__form').ajaxSubmit({
						data: {
							action: 'reorder'
						},
						success: function() {
							$('.errors').empty();
						},
						error: function() {
							$('.errors').empty();
							$('.errors').append('<div class="alert alert-danger">[[Oops... Something went wrong. Please try again!]]</div>');
						}
					});
				}
			});

			$('.sortable-handle').disableSelection();
		});
	</script>
{/javascript}