<?php

return [
    'SL-223', function() {
        $phrases = [
            [
                'en' => 'FREE resume evaluation by a professional resume expert from TopResume',
                'de' => '',
                'fr' => '',
                'es' => '',
                'ru' => 'БЕСПЛАТНАЯ оценка резюме профессиональным резюме экспертом из TopResume',
            ],
        ];

        $success = true;
        foreach (['de', 'en', 'es', 'fr', 'ru', 'nl', 'ro'] as $lang) {
            $langFile = SJB_BASE_DIR . "languages/{$lang}.pages.xml";
            if (!file_exists($langFile)) {
                continue;
            }
            $contents = file_get_contents($langFile);
            foreach ($phrases as $phrase) {
                $trans = $phrase[$lang];
                $phrase = $phrase['en'];
                $contents = str_replace(
                    '<page key="Frontend">',
                    sprintf(
                        join("\n", [
                            '<page key="Frontend">',
                            '      <string key="%s">',
                            '        <tr lang="%s"> %s </tr>',
                            '      </string>',
                        ]),
                        XML_Util::replaceEntities($phrase),
                        $lang,
                        XML_Util::replaceEntities($trans)
                    ),
                    $contents
                );
            }
            $success &= (bool) file_put_contents($langFile, $contents);
        }
        return $success;
    },
    'SL-245', function() {
        $plugin = SJB_BASE_DIR . 'system/plugins/google_plus_integration_plugin';
        if (file_exists($plugin)) {
            $iterator = new RecursiveDirectoryIterator($plugin, FilesystemIterator::SKIP_DOTS);
            $iterator = new RecursiveIteratorIterator($iterator, RecursiveIteratorIterator::CHILD_FIRST);
            foreach ($iterator as $file) {
                if ($file->isDir()) {
                    @rmdir($file->getPathName());
                }
                @unlink($file->getPathName());
            }
            @rmdir($plugin);
        }
        SJB_DB::query('drop table if exists `google`');
        SJB_DB::query('delete from `settings` where `name` in (?l)', [
            "developer_key", "client_secret", "oauth2_client_id", "soc_network", "signup_jobseeker_googleplus",
            "signup_employer_googleplus", "passed_parameters_via_uri", "default_page_template_by_http",
            "li_resumeWidget", "li_companyWidget", "fb_shareJob", "fb_shareResume", "display_for_all_pages", "get_keyword_from_file", "captcha_max_allowed_auth_attempts"
        ]);
        return true;
    },
    'SL-237', function() {
        $success = (bool) SJB_DB::query('update `listing_fields` set `type` = "string" where `id` = "access_type"');
        SJB_DB::query('alter table `listing_fields` drop `sort_by_alphabet`');
        return $success;
    },
    'tree-cleanup', function() {
        $success = (bool) SJB_DB::query('ALTER TABLE `listing_fields`
            DROP `level_1`,
            DROP `level_2`,
            DROP `level_3`,
            DROP `level_4`,
            DROP `signs_num`;
        ');
        $success &= (bool) SJB_DB::query('ALTER TABLE `listing_complex_fields`
            DROP `signs_num`;
        ');
        $success &= (bool) SJB_DB::query('ALTER TABLE `user_profile_fields`
            DROP `level_1`,
            DROP `level_2`,
            DROP `level_3`,
            DROP `level_4`;
        ');
        return $success;
    },
    '5.0.7', function() {
        ThemeManager::compileStyles();
        SJB_TemplateProcessor::deleteCache();
        return true;
    },
];
