<?php

return [
    'SL-232', function() {
        $success = (bool) SJB_DB::query('ALTER TABLE `products` ADD `recurring` TINYINT NOT NULL DEFAULT "0";');
        $success &= (bool) SJB_DB::query('INSERT INTO `email_templates` (`sid`, `name`, `group`, `cc`, `subject`, `text`, `hidden`) VALUES (NULL, \'Recurring Payment Failed\', \'product\', \'\', \'Payment Failed\', ?s, \'0\');',
            "<p>Hello {\$user.FullName},</p>\r\n<p>Your recurring payment for \"{\$product.caption}\" on {\$GLOBALS.settings.site_title} was failed.</p>\r\n<p>The subscription is now canceled.</p>\r\n<p>Payment details: \"{\$product.caption}\" - {currencyFormat amount=\$product.price}</p>\r\n<p>----</p>\r\n<p>Sub total: {currencyFormat amount=\$invoice.sub_total}</p>\r\n<p>{if \$invoice.tax} Taxes: {currencyFormat amount=\$invoice.tax} {/if}</p>\r\n<p>Grand total: {currencyFormat amount=\$invoice.total}</p>\r\n<p>Please make sure your credit/debit card has sufficient available funds and your card is not expired.</p>\r\n<p>You can renew your subscription by subscribing again on our website.</p>\r\n<p>Thanks,<br />The {\$GLOBALS.settings.site_title} team</p>"
        );
        $success &= (bool) SJB_DB::query('ALTER TABLE `invoices` ADD `recurring_id` VARCHAR(255) NULL DEFAULT \'\'');
        $success &= (bool) SJB_DB::query('ALTER TABLE `contracts` CHANGE `status` `status` VARCHAR(255) NOT NULL DEFAULT \'active\';');
        $success &= (bool) SJB_DB::query('ALTER TABLE `listings` DROP `featured_expiration`;');

        $phrases = [
            'per month' => [
                'en' => 'per month',
                'ru' => 'в месяц',
            ],
            'per year' => [
                'en' => 'per year',
                'ru' => 'в год',
            ],
            'Are you sure you\'d like to cancel your subscription?' => [
                'en' => 'Are you sure you\'d like to cancel your subscription?',
                'ru' => 'Отменить подписку?',
            ],
            'Canceled' => [
                'en' => 'Canceled',
                'ru' => 'Отменен',
            ]
        ];

        foreach (['de', 'en', 'es', 'fr', 'ru', 'nl', 'ro'] as $lang) {
            $langFile = SJB_BASE_DIR . "languages/{$lang}.pages.xml";
            if (!file_exists($langFile)) {
                continue;
            }
            $contents = file_get_contents($langFile);
            foreach ($phrases as $phrase => $translations) {
                $trans = '';
                if (!empty($translations[$lang])) {
                    $trans = $translations[$lang];
                }
                $contents = str_replace(
                    '<page key="Frontend">',
                    sprintf(
                        join("\n", [
                            '<page key="Frontend">',
                            '      <string key="%s">',
                            '        <tr lang="%s"> %s </tr>',
                            '      </string>',
                        ]),
                        XML_Util::replaceEntities($phrase),
                        $lang,
                        XML_Util::replaceEntities($trans)
                    ),
                    $contents
                );
            }
            $success &= (bool) file_put_contents($langFile, $contents);
        }
        return $success;
    },
    'SL-252', function() {
        return (bool) SJB_DB::query('alter table `products` add `deleted` tinyint(1) NOT NULL DEFAULT "0", ADD INDEX(`deleted`);');
    },
    'SL_251', function() {
        $stripePosition = SJB_DB::queryValue('select `position` from `payment_gateways` where `id` = "stripe"');
        SJB_DB::query('update `payment_gateways` set `position` = `position` + 1 where `position` > ?n', $stripePosition);
        return (bool) SJB_DB::query("INSERT INTO `payment_gateways` (`sid`, `id`, `name`, `caption`, `active`, `position`) VALUES (NULL, 'paypal_express', 'PayPal Express', 'PayPal', '0', ?n)", $stripePosition + 1);
    },
    'SL-274', function() {
        SJB_Settings::saveSetting('facebook_footer', '<p style="text-align: right;">Powered by <a target="_top" href="http://www.smartjobboard.com">SmartJobBoard.com</a></p>');
        return true;
    },
    'SL-275', function() {
        $success = true;
        $phrases = [
            'apply clicks' => [
                'en' => 'apply clicks',
                'ru' => 'переходов',
            ],
            'This application will be removed permanently. Are you sure?' => [
                'en' => 'This application will be removed permanently. Are you sure?',
                'ru' => 'Эта заявка будет удалена. Вы уверены?',
            ],
            'You\'re about to be taken to another website to complete your application.' => [
                'en' => 'You\'re about to be taken to another website to complete your application.',
                'ru' => 'Вы будете отправлены на другой сайт для завершения подачи заявки.',
            ],
            'Continue' => [
                'en' => 'Continue',
                'ru' => 'Продолжить',
            ],
        ];

        foreach (['de', 'en', 'es', 'fr', 'ru', 'nl', 'ro', 'th'] as $lang) {
            $langFile = SJB_BASE_DIR . "languages/{$lang}.pages.xml";
            if (!file_exists($langFile)) {
                continue;
            }
            $contents = file_get_contents($langFile);
            foreach ($phrases as $phrase => $translations) {
                $trans = '';
                if (!empty($translations[$lang])) {
                    $trans = $translations[$lang];
                }
                $contents = str_replace(
                    '<page key="Frontend">',
                    sprintf(
                        join("\n", [
                            '<page key="Frontend">',
                            '      <string key="%s">',
                            '        <tr lang="%s"> %s </tr>',
                            '      </string>',
                        ]),
                        XML_Util::replaceEntities($phrase),
                        $lang,
                        XML_Util::replaceEntities($trans)
                    ),
                    $contents
                );
            }
            $success &= (bool) file_put_contents($langFile, $contents);
        }
        $success &= (bool) SJB_DB::query('ALTER TABLE `listings` ADD `application_redirects` INT NOT NULL DEFAULT \'0\';');
        $success &= (bool) SJB_DB::query('ALTER TABLE `applications` ADD `hidden` TINYINT NOT NULL DEFAULT \'0\', ADD INDEX(`hidden`)');
        return $success;
    },
    '5.0.8', function() {
        ThemeManager::compileStyles();
        SJB_TemplateProcessor::deleteCache();
        return true;
    },
];
